﻿var currItem = 0;
var timeout = 5;
var slideSpeed = 1;
var slideStep = 5;
var advBoxPadding = 3;

function startRequest()
{
  var advBox = document.getElementById("advBox");
  advBox.innerHTML = "Trwa wczytywanie danych...";
  url = "http://localhost/adv.php";
  startGETRequest(url, onComplete, onEnd);
}

function startAdvShow()
{
  var advBox = document.getElementById("advBox");
  var divs = advBox.getElementsByTagName("div");

  if(divs.length < 1) return;

  if(++currItem >= divs.length) currItem = 0;
  if(currItem == 0)
    prevItem = divs.length - 1;
  else
    prevItem = currItem - 1;

  var currDiv = divs[currItem];
  var prevDiv = divs[prevItem];
  currDiv.style.zIndex = 1001;
  prevDiv.style.zIndex = 1000;

  xPos = parseInt(currDiv.parentNode.offsetWidth);
  currDiv.style.left = xPos + "px";
  currDiv.style.display = "block";

  slideDiv(prevItem, currItem);
}

function slideDiv(prevItem, currItem)
{
  var advBox = document.getElementById("advBox");
  var divs = advBox.getElementsByTagName("div");
  var currDiv = divs[currItem];
  var prevDiv = divs[prevItem];

  xPos = parseInt(currDiv.style.left);
  xPos -= slideStep;
  if(xPos < advBoxPadding){
    xPos = advBoxPadding;
    prevDiv.style.display = "none";
    currDiv.style.left = xPos + "px";
    setTimeout("startAdvShow();", timeout * 1000);
  }
  else{
    currDiv.style.left = xPos + "px";
    setTimeout("slideDiv(prevItem, currItem);", slideSpeed);
  }
}

function onComplete(text, xml)
{
  if(text == 'error'){
    var advBox = document.getElementById("advBox");
    advBox.innerHTML = "Reklamy nie są dostępne.";
  }
  else{
    var advBox = document.getElementById("advBox");
    advBox.innerHTML = "";
    items = text.split("\n\n");
    var count = 0;
    for(i = 0; i < items.length; i++){
      var div = document.createElement("div");

      if(count > 0) div.style.display = "none"
      else div.style.display = "block";

      div.id = "advBox" + count++;
      div.className = "advBoxDiv";

      advBox.appendChild(div);
      div.style.width = (div.parentNode.clientWidth - 2 * 
                         advBoxPadding) + "px";
      div.style.height = div.parentNode.offsetHeight + "px";

      div.innerHTML = items[i];
    }
    setTimeout("startAdvShow();", timeout * 1000);
  }
}

function onEnd()
{
}
